--------------------------------------------------------------------------------------------
-- convert cat file hex to binary one line per rule

-- \n(.)(........)
-- \n\2\1
--------------------------------------------------------------------------------------------
local function numberToBinStr(x)
   ret=""
   for i = 1,9 do
      ret=tostring(x%2)..ret
      x=math.modf(x/2)
   end
   return ret
end
--------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------

local catFileName = "../surveydownloadCat.txt"
local catFile = io.open ( catFileName , "r")
local outFileName = "../surveydownloadCat_Bin.txt"
local outFile = io.open ( outFileName , "w")

local line = catFile:read("*line")
while line do
   if(line:sub(1,1) == 'H') then
      r1 = line:sub(1,4)
      r2 = line:sub(6,9)
      v1 = tonumber(r1:sub(2), 16)
      v2 = tonumber(r2:sub(2), 16)
      txt = line:sub(10)
      outFile:write(numberToBinStr(v1)..","..r1..txt.."\n")
      outFile:write(numberToBinStr(v2)..","..r2..txt.."\n")
      v1 = tonumber(r1:sub(1), 16)
   elseif(line:sub(1,1) == 'R') then
      outFile:write("Binary,"..line:sub(1,5)..line:sub(11).."\n")
   else
      outFile:write(line:sub(1,1).."**"..line.."\n")
   end
   line = catFile:read("*line")
end
